set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 11: Industry contributions to predicted within-industry & between-industry change in laborshare, all weighted across countries.

**1. Table 11, final column (predicted within-industry change by decade)
use $path_out\Table9_predictions_within, clear	

	*Calculate weighted means across industries
		foreach var of varlist DE* {
			bysort country year: egen mean`var'=sum(`var'*weight)
		}	
		foreach var of varlist DH* {
			bysort country year: egen mean`var'=sum(`var'*weight_h)
		}	
		foreach var of varlist DYn* DYr* DLS* {
			bysort country year: egen mean`var'=sum(`var'*weight_VA)
		}	
	*Summing country weights across industries
		foreach var in weight_c weight_h_c weight_VA_c {
			bysort country year: egen tot`var'=sum(`var')
		}

		*Drop industry dimension	
		duplicates drop country year, force
		drop code
		keep country year decade mean* tot*
			renvars mean*, predrop(4)
			renvars tot*, predrop(3)
		
	*Calculate weighted means across countries
		foreach var of varlist DE* {
			bysort year: egen mean`var'=sum(`var'*weight_c)
		}	
		foreach var of varlist DH* {
			bysort year: egen mean`var'=sum(`var'*weight_h_c)
		}	
		foreach var of varlist DYn* DYr* DLS* {
			bysort year: egen mean`var'=sum(`var'*weight_VA_c)
		}	
		*Drop country dimension	
		duplicates drop year, force
		replace country="all"
		drop weight*

	*Calculate unweighted means across years, within decades
		collapse (mean) meanD*, by(country decade)
		renvars mean*, predrop(4)
		
	table decade, c(mean DLS_net) /*Table 11, final column*/
	

**2. Table 11, prefinal column (predicted between-industry change by decade)
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	gen decade=1970 if year<=1980
	replace decade=1980 if year>1980&year<=1990
	replace decade=1990 if year>1990&year<=2000
	replace decade=2000 if year>2000
	
	preserve
		**Store mean VA shares by country-industry-decade
		keep country code decade year VA
		bysort country year: egen totVA=sum(VA)
		gen VAshare=VA/totVA
		collapse (mean) VAshare, by(country code)
		table country, c(sum VAshare)
	save $path_temp\temp_meanVA, replace
	restore

	preserve
		**Store mean log laborshare by country-industry-decade
		keep country code decade year weight* VA laborshare
		replace laborshare=laborshare/100
		gen lnlaborshare=ln(laborshare)
		collapse (mean) lnlaborshare, by(country code)
		save $path_temp\temp_meanLS, replace
	restore
	
clear	

		
	*Predicted between-industry change in laborshare by country-industry-year
	use $path_out\Table9_predictions_within, clear	

	keep country code code_hier decade sectorgroup year DYn*

	*Total predicted output changes across years within countries, over 37-year period
		gen nryrs=1
		collapse (sum) DYn* nryrs, by(country code code_hier decade)

		*Merge in average VA and lnlaborshare
		merge m:1 country code using $path_temp\temp_meanVA.dta
		drop _
		merge m:1 country code using $path_temp\temp_meanLS.dta 
		drop _
		rename VAshare omega_ic
		
		*Convert percentage change in nominal VA to changes in VA shares	
			*Calculate % change in VA by country-industry
		gen DVA=exp(DYn_net/100) /*total % change in output by country-industry*/
			*Calculate change in VA share by country-industry
		gen omega_ic_hat=omega_ic*DVA
		bysort country decade: egen totomega_ic_hat=sum(omega_ic_hat)
		gen Domega_ic_hat=(omega_ic_hat/totomega_ic_hat)-omega_ic
		table code decade, c(mean Domega_ic_hat)
			*Annualize and express as 100 x log change	
			replace Domega_ic_hat=Domega_ic_hat/nryrs*100
		
			table country decade, c(mean Domega_ic_hat sum Domega_ic_hat ) /*share changes sum to zero within countries*/
			table code decade, c(mean Domega_ic_hat) /*Predicted VA share change by industry, unweighted average across countries*/
			
		*Calculate implied laborshare change by country from VA change
		gen DLS_net_ind=Domega_ic_hat*lnlaborshare
		bysort country decade: egen DLS_net=sum(DLS_net)

		keep country code decade code_hier DLS_net_ind DLS_net
		label var DLS_net "Annual predicted log laborshare change from between effect by country, log points"
		label var DLS_net_ind "Contribution of industry"
		table decade, c(mean DLS_net)
		
		*Merge in country weights
		replace decade=decade+10
		merge m:1 country decade using $path_in\country_weights_bydecade
		keep if _==3
		drop _
		replace decade=decade-10

		*Remove industry dimension
		duplicates drop country decade, force
		drop code

		*Construct weighted average across countries
		replace country="all"
		collapse (mean) DLS_net [w=weight_ls], by(country decade) 
	
	list /*Table 11, prefinal column*/
	
	
*Erase temporary files
	erase $path_temp\temp_meanVA.dta
	erase $path_temp\temp_meanLS.dta
